/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.PaintEvent;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import sun.awt.CausedFocusEvent;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XEmbedChildProxy;
import sun.awt.X11.XEmbeddingContainer;
import sun.awt.X11.XEvent;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XKeyboardFocusManagerPeer;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XSizeHints;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XlibWrapper;
import sun.java2d.pipe.Region;

public class XEmbedChildProxyPeer
implements ComponentPeer,
XEventDispatcher {
    XEmbeddingContainer container;
    XEmbedChildProxy proxy;
    long handle;

    XEmbedChildProxyPeer(XEmbedChildProxy xEmbedChildProxy) {
        this.container = xEmbedChildProxy.getEmbeddingContainer();
        this.handle = xEmbedChildProxy.getHandle();
        this.proxy = xEmbedChildProxy;
        this.initDispatching();
    }

    void initDispatching() {
        XToolkit.awtLock();
        try {
            XToolkit.addEventDispatcher(this.handle, this);
            XlibWrapper.XSelectInput(XToolkit.getDisplay(), this.handle, 0x420000L);
        }
        finally {
            XToolkit.awtUnlock();
        }
        this.container.notifyChildEmbedded(this.handle);
    }

    @Override
    public boolean isObscured() {
        return false;
    }

    @Override
    public boolean canDetermineObscurity() {
        return false;
    }

    @Override
    public void setVisible(boolean bl) {
        if (!bl) {
            XToolkit.awtLock();
            try {
                XlibWrapper.XUnmapWindow(XToolkit.getDisplay(), this.handle);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        XToolkit.awtLock();
        try {
            XlibWrapper.XMapWindow(XToolkit.getDisplay(), this.handle);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    @Override
    public void setEnabled(boolean bl) {
    }

    @Override
    public void paint(Graphics graphics) {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    @Override
    public void print(Graphics graphics) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBounds(int n, int n2, int n3, int n4, int n5) {
        XToolkit.awtLock();
        try {
            XlibWrapper.XMoveResizeWindow(XToolkit.getDisplay(), this.handle, n, n2, n3, n4);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    @Override
    public void handleEvent(AWTEvent aWTEvent) {
        switch (aWTEvent.getID()) {
            case 1004: {
                XKeyboardFocusManagerPeer.getInstance().setCurrentFocusOwner(this.proxy);
                this.container.focusGained(this.handle);
                break;
            }
            case 1005: {
                XKeyboardFocusManagerPeer.getInstance().setCurrentFocusOwner(null);
                this.container.focusLost(this.handle);
                break;
            }
            case 401: 
            case 402: {
                if (((InputEvent)aWTEvent).isConsumed()) break;
                this.container.forwardKeyEvent(this.handle, (KeyEvent)aWTEvent);
            }
        }
    }

    @Override
    public void coalescePaintEvent(PaintEvent paintEvent) {
    }

    @Override
    public Point getLocationOnScreen() {
        XWindowAttributes xWindowAttributes = new XWindowAttributes();
        XToolkit.awtLock();
        try {
            XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), this.handle, xWindowAttributes.pData);
            Point point = new Point(xWindowAttributes.get_x(), xWindowAttributes.get_y());
            return point;
        }
        finally {
            XToolkit.awtUnlock();
            xWindowAttributes.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getPreferredSize() {
        XToolkit.awtLock();
        long l = XlibWrapper.XAllocSizeHints();
        try {
            Dimension dimension;
            XSizeHints xSizeHints = new XSizeHints(l);
            XlibWrapper.XGetWMNormalHints(XToolkit.getDisplay(), this.handle, l, XlibWrapper.larg1);
            Dimension dimension2 = dimension = new Dimension(xSizeHints.get_width(), xSizeHints.get_height());
            return dimension2;
        }
        finally {
            XlibWrapper.XFree(l);
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getMinimumSize() {
        XToolkit.awtLock();
        long l = XlibWrapper.XAllocSizeHints();
        try {
            Dimension dimension;
            XSizeHints xSizeHints = new XSizeHints(l);
            XlibWrapper.XGetWMNormalHints(XToolkit.getDisplay(), this.handle, l, XlibWrapper.larg1);
            Dimension dimension2 = dimension = new Dimension(xSizeHints.get_min_width(), xSizeHints.get_min_height());
            return dimension2;
        }
        finally {
            XlibWrapper.XFree(l);
            XToolkit.awtUnlock();
        }
    }

    @Override
    public ColorModel getColorModel() {
        return null;
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    @Override
    public Graphics getGraphics() {
        return null;
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return null;
    }

    @Override
    public void dispose() {
        this.container.detachChild(this.handle);
    }

    @Override
    public void setForeground(Color color) {
    }

    @Override
    public void setBackground(Color color) {
    }

    @Override
    public void setFont(Font font) {
    }

    @Override
    public void updateCursorImmediately() {
    }

    void postEvent(AWTEvent aWTEvent) {
        XToolkit.postEvent(XToolkit.targetToAppContext(this.proxy), aWTEvent);
    }

    boolean simulateMotifRequestFocus(Component component, boolean bl, boolean bl2, long l) {
        Component component2;
        if (component == null) {
            component = this.proxy;
        }
        if ((component2 = XKeyboardFocusManagerPeer.getInstance().getCurrentFocusOwner()) != null && component2.getPeer() == null) {
            component2 = null;
        }
        FocusEvent focusEvent = new FocusEvent(component, 1004, false, component2);
        FocusEvent focusEvent2 = null;
        if (component2 != null) {
            focusEvent2 = new FocusEvent(component2, 1005, false, component);
        }
        if (focusEvent2 != null) {
            this.postEvent(XComponentPeer.wrapInSequenced(focusEvent2));
        }
        this.postEvent(XComponentPeer.wrapInSequenced(focusEvent));
        return true;
    }

    @Override
    public boolean requestFocus(Component component, boolean bl, boolean bl2, long l, CausedFocusEvent.Cause cause) {
        int n = XKeyboardFocusManagerPeer.shouldNativelyFocusHeavyweight(this.proxy, component, bl, false, l, cause);
        switch (n) {
            case 0: {
                return false;
            }
            case 2: {
                Window window;
                Container container;
                for (container = this.proxy.getParent(); container != null && !(container instanceof Window); container = container.getParent()) {
                }
                if (container != null && !(window = (Window)container).isFocused() && XKeyboardFocusManagerPeer.getInstance().getCurrentFocusedWindow() == window) {
                    return true;
                }
                return this.simulateMotifRequestFocus(component, bl, bl2, l);
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public Image createImage(ImageProducer imageProducer) {
        return null;
    }

    @Override
    public Image createImage(int n, int n2) {
        return null;
    }

    @Override
    public VolatileImage createVolatileImage(int n, int n2) {
        return null;
    }

    @Override
    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return false;
    }

    @Override
    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return 0;
    }

    @Override
    public GraphicsConfiguration getGraphicsConfiguration() {
        return null;
    }

    @Override
    public boolean handlesWheelScrolling() {
        return true;
    }

    @Override
    public void createBuffers(int n, BufferCapabilities bufferCapabilities) throws AWTException {
    }

    @Override
    public Image getBackBuffer() {
        return null;
    }

    @Override
    public void flip(int n, int n2, int n3, int n4, BufferCapabilities.FlipContents flipContents) {
    }

    @Override
    public void destroyBuffers() {
    }

    @Override
    public void layout() {
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public void show() {
        this.setVisible(true);
    }

    public void hide() {
        this.setVisible(false);
    }

    public void enable() {
    }

    public void disable() {
    }

    public void reshape(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3, n4, 3);
    }

    Window getTopLevel(Component component) {
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        return (Window)component;
    }

    void childResized() {
        XToolkit.postEvent(XToolkit.targetToAppContext(this.proxy), new ComponentEvent(this.proxy, 101));
        this.container.childResized(this.proxy);
    }

    void handlePropertyNotify(XEvent xEvent) {
        XPropertyEvent xPropertyEvent = xEvent.get_xproperty();
        if (xPropertyEvent.get_atom() == 40L) {
            this.childResized();
        }
    }

    void handleConfigureNotify(XEvent xEvent) {
        this.childResized();
    }

    @Override
    public void dispatchEvent(XEvent xEvent) {
        int n = xEvent.get_type();
        switch (n) {
            case 28: {
                this.handlePropertyNotify(xEvent);
                break;
            }
            case 22: {
                this.handleConfigureNotify(xEvent);
            }
        }
    }

    void requestXEmbedFocus() {
        this.postEvent(new InvocationEvent((Object)this.proxy, new Runnable(){

            @Override
            public void run() {
                XEmbedChildProxyPeer.this.proxy.requestFocusInWindow();
            }
        }));
    }

    @Override
    public void reparent(ContainerPeer containerPeer) {
    }

    @Override
    public boolean isReparentSupported() {
        return false;
    }

    public Rectangle getBounds() {
        XWindowAttributes xWindowAttributes = new XWindowAttributes();
        XToolkit.awtLock();
        try {
            XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), this.handle, xWindowAttributes.pData);
            Rectangle rectangle = new Rectangle(xWindowAttributes.get_x(), xWindowAttributes.get_y(), xWindowAttributes.get_width(), xWindowAttributes.get_height());
            return rectangle;
        }
        finally {
            XToolkit.awtUnlock();
            xWindowAttributes.dispose();
        }
    }

    public void setBoundsOperation(int n) {
    }

    @Override
    public void applyShape(Region region) {
    }

    @Override
    public void setZOrder(ComponentPeer componentPeer) {
    }

    @Override
    public boolean updateGraphicsData(GraphicsConfiguration graphicsConfiguration) {
        return false;
    }
}

